﻿module File1

open CommandLine

type options = {
  [<Option('r', "read", Required = true, HelpText = "Input files.")>] files : seq<string>;
  [<Option(HelpText = "Prints all messages to standard output.")>] verbose : bool;
  [<Option(Default = "Russian", HelpText = "Content language.")>] language : string;
  [<Value(0, MetaName="offset", HelpText = "File offset.")>] offset : int64 option;
}

let run opt =  
  printfn "parser success"
  printfn "Files= %A" opt.files


[<EntryPoint>]
let main argv =
  let result = CommandLine.Parser.Default.ParseArguments<options>(argv)
  match result with
      | :? Parsed<options> as parsed -> run parsed.Value     
      | :? NotParsed<'a> as notParsed  -> ()

  0